﻿<?LassoScript
	
	/*
			This page displays all the blog entries created by a given user. If
		the current user is the blog's owner, then each entry will have a link
		that can be used to delete that entry and the New Blog Entry form will
		be shown.
	*/
	
	if(action_param('list')); // this action param must be provided
							// the value is the name of the blog owner
		local('list' = action_param('list'));
		// these params are available if the owner is creating a new blog entry
		local('newPost' = action_param('newPost'), 
				'postTitle' = action_param('postTitle'), 
				'postBody' = action_param('postBody'));
		// this param is available if the user is deleting a blog entry
		local('del' = action_param('del'));
		// search for the blog by author name
		inline(-database='op_blog', -table='blogs', -op='eq', 'author'=#list, -search);
			$handled = true;
			if (found_count == 0); // if the blog was not found...
			'<div class="group_list">\
				<div class="group">\
					<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
					<div class="group_title">
						The author was not found.
					</div>\
				</div>\
			</div>';
			else;
				// the current user is the blog's owner if the username and author name match
				local('isOwner' = #list == admin_currentusername);
				local('blogId' = field('id'));
				if (#isOwner && #newPost); // if this is the owner and they are creating a new blog entry...
					inline(-table='entries', -add, 'id_blog'=field('id'), 'title'=#postTitle, 'body'=#postBody);
					/inline;
				/if;
				if (#isOwner && #del); // if this is the owner and they are deleting a blog entry...
					inline(-table='entries', -search, -op='eq', 'id'=#del, -returnField='id_blog');
						if (field('id_blog') == #blogId);
							// after confirming that the entry belongs to this blog, delete it
							inline(-table='entries', -delete, -keyField='id', -keyValue=#del);
							/inline;
						/if;
					/inline;
				/if;
				// display the blog information
			'<div class="group_list">\
				<div class="group">\
					<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
					<div class="group_title"><a href="'Application_appInfo->indexFile'">Blogs</a> &gt; '
						encode_html(field('title'))' by <i>'encode_html(field('author'))'</i>\
						<div class="group_description">'encode_html(field('description'))'</div>\
					</div>';
				// search for all the entries for this blog
				inline(-table='entries', -op='eq', 'id_blog'=field('id'), -search, 
						-returnField='id', -returnField='title', -returnField='date', 
						-sortField='date', -sortOrder='descending');
					if (found_count == 0);
					'<div class="item">\
						<div class="item_title">No Blog Entries</div>\
						<div class="item_details">No blog entries have been posted by this author.</div>\
					</div>';
					else;
						records; // display the information for each entry
						'<div class="item">\
							<div class="item_title"><a href="'Application_appInfo->indexFile'?detail='field('id')'">'encode_html(field('title'))'</a>';
							(#isOwner? ' - <a class="delete" href="'Application_appInfo->indexFile'?list='#list'&amp;del='field('id')'">(delete entry)</a>');
							'</div>
							<div class="item_description">Posted on 'field('date')'</div>\
							<div class="item_details">';
							// find the number of comments for this entry
							inline(-table='comments', -op='eq', 'id_entry'=field('id'), -search,
									-returnField='id');
								found_count + ' comment' (found_count != 1 ? 's');
							/inline;
							'</div>\
						</div>';
						/records;
					/if;
				/inline;
				'</div>';
				if (#isOwner); // if the current user is the blog's owner, display the New Blog Entry form
				'<div class="group">\
					<b class="rboth1 rrightclr"></b><b class="rboth2 rrightclr"></b><b class="rboth3 rrightclr"></b><b class="rboth4 rrightclr"></b>\
					<div class="group_title">Post New Blog Entry</div>\
					<div class="item">\
						<form method="POST" action="'Application_appInfo->indexFile'">\
							<input type="hidden" name="list" value="'#list'" />\
							Entry Title<br />
							<input type="text" name="postTitle" size="50" value="" /><br />
							Entry Text<br />
							<textarea name="postBody" style="width: 80%; height: 100px"></textarea><br />
							<input type="submit" value="Post New Entry" name="newPost" />\
						</form>\
					</div>\
				</div>';
				/if;
			'</div>';			
			/if;
		/inline;	
	/if;
?>